# -------------------------------------------------------- 
# SharePoint 2013 Advanced WCM - Sample Code 
# by John Chapman
# (c) Packt Publishing
#
# Get device channel mappings for all sites in a site 
# collection
# -------------------------------------------------------- 

# -------------------------------------------------------- 
# VARIABLES
# Replace the variable values appropriately
# -------------------------------------------------------- 

# URL to the SharePoint site collection
$siteUrl = "http://sharepoint/site"

# -------------------------------------------------------- 
# END VARIABLES
# -------------------------------------------------------- 

# -------------------------------------------------------- 
# SCRIPT
# -------------------------------------------------------- 

# Add the SharePoint PowerShell snap-in
Add-PSSnapin Microsoft.SharePoint.PowerShell -ErrorAction SilentlyContinue

# Load the required SharePoint assemblies
[Reflection.Assembly]::LoadFrom("C:\Program Files\Common Files\microsoft shared\Web Server Extensions\15\ISAPI\Microsoft.SharePoint.Publishing.dll")
[Reflection.Assembly]::LoadFrom("C:\Program Files\Common Files\microsoft shared\Web Server Extensions\15\ISAPI\Microsoft.SharePoint.dll")

# Get the Site Collection
$site = Get-SPSite $siteUrl

# Get the types requires to construct the mapping file
$typeWeb = [Microsoft.SharePoint.SPWeb]
$typeBool = [System.Boolean]
$typeMappingFile = [System.Type]::GetType("Microsoft.SharePoint.Publishing.Mobile.MasterPageMappingsFile, Microsoft.SharePoint.Publishing, Version=15.0.0.0, Culture=neutral, PublicKeyToken=71e9bce111e9429c")

# Get the constructor for the mapping file
$consMappingFileParams = ($typeWeb, $typeBool, $typeWeb)
$consMappingFile = $typeMappingFile.GetConstructor($consMappingFileParams)

# Create the default parameter array for constructing the mapping file
$mappingFileParams = [System.Array]::CreateInstance([System.Object], 3)
$mappingFileParams[1] = $false
$mappingFileParams[2] = $null

# Iterate through each Site in the Site Collection
foreach ($web in $site.AllWebs)
{
	# Add the Site to the parameter array
	$mappingFileParams[0] = [Microsoft.SharePoint.SPWeb] $web

	# Construct the mapping file
	$mappingFile = $consMappingFile.Invoke($mappingFileParams)

	# Output the default channel details
	Write-Host ""
	Write-Host "Site: " $web.Url
	Write-Host "Device Channel: Default"
	Write-Host "Master Page: " $web.CustomMasterUrl

	# Iterate through each mapping in the mapping file
	foreach ($key in $mappingFile.Keys)
	{
		# Output the channel details
		Write-Host ""
		Write-Host "Site: " $web.Url
		Write-Host "Device Channel: " $key
		Write-Host "Master Page: " $mappingFile[$key].MasterPageUrl
	}

	# Dispose of the site object
	$web.Dispose()
}

# Dispose of the site collection object
$site.Dispose()

# -------------------------------------------------------- 
# END SCRIPT
# -------------------------------------------------------- 